definition module Highscore

/*
	General utility for reading/writing high scores to Files and displaying current high scores.
	This module uses the 0.8 I/O library.
*/

from	StdFile			import	Files
from	StdString		import	String
from	deltaEventIO	import	IOState
from	deltaIOSystem	import	DialogId

::	*HiScores	:== (!Files,!Highs)
::	Highs		:== [High]
::	High
	=	{	name	:: !String
		,	score	:: !Int
		}

// Read high score file from disk:
ReadHiScores	:: !String !Files		-> (!*File,!HiScores)

// Write high scores to disk:
WriteHiScores	:: !*File  !HiScores	-> Files

//	Determine whether, given the number of high scores, a given score is actually a new high score:
ItsAHighScore	:: !Int !Int !Highs		-> Bool

//	Add, given the number of high scores, a High to the current list of high scores:
AddScore		:: !Int !High !Highs	-> Highs

// Display current high scores to user in a modal dialog with given DialogId:
ShowHiScores	:: DialogId String !Highs !*s !(IOState *s)	-> (!*s,!IOState *s)
